/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class EqualsAvoidNullCheck
extends Check {
    private boolean ignoreEqualsIgnoreCase;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{27};
    }

    @Override
    public void visitToken(DetailAST methodCall) {
        DetailAST dot = methodCall.getFirstChild();
        if (dot.getType() != 59) {
            return;
        }
        DetailAST objCalledOn = dot.getFirstChild();
        if (objCalledOn.getType() == 139 || objCalledOn.getType() == 136 || objCalledOn.getType() == 59) {
            return;
        }
        DetailAST method = objCalledOn.getNextSibling();
        DetailAST expr = dot.getNextSibling().getFirstChild();
        if ("equals".equals(method.getText()) && this.containsOneArg(expr) && this.containsAllSafeTokens(expr)) {
            this.log(methodCall.getLineNo(), methodCall.getColumnNo(), "equals.avoid.null", new Object[0]);
        }
        if (!this.ignoreEqualsIgnoreCase && "equalsIgnoreCase".equals(method.getText()) && this.containsOneArg(expr) && this.containsAllSafeTokens(expr)) {
            this.log(methodCall.getLineNo(), methodCall.getColumnNo(), "equalsIgnoreCase.avoid.null", new Object[0]);
        }
    }

    private boolean containsNoArgs(AST expr) {
        return expr == null;
    }

    private boolean containsMultiArgs(AST expr) {
        AST comma = expr.getNextSibling();
        return comma != null && comma.getType() == 74;
    }

    private boolean containsOneArg(AST expr) {
        return !this.containsNoArgs(expr) && !this.containsMultiArgs(expr);
    }

    private boolean containsAllSafeTokens(DetailAST expr) {
        DetailAST arg = expr.getFirstChild();
        if (arg.branchContains(27)) {
            return false;
        }
        return !(arg = this.skipVariableAssign(arg)).branchContains(98) && !arg.branchContains(58);
    }

    private DetailAST skipVariableAssign(DetailAST currentAST) {
        if (currentAST.getType() == 80 && currentAST.getFirstChild().getType() == 58) {
            return currentAST.getFirstChild().getNextSibling();
        }
        return currentAST;
    }

    public void setIgnoreEqualsIgnoreCase(boolean newValue) {
        this.ignoreEqualsIgnoreCase = newValue;
    }
}

