/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.beanutils.ConversionException;

public abstract class AbstractHeaderCheck
extends AbstractFileSetCheck {
    private String filename;
    private String charset = System.getProperty("file.encoding", "UTF-8");
    private final List<String> readerLines = Lists.newArrayList();

    protected ImmutableList<String> getHeaderLines() {
        return ImmutableList.copyOf(this.readerLines);
    }

    public void setCharset(String charset) throws UnsupportedEncodingException {
        if (!Charset.isSupported(charset)) {
            String message = "unsupported charset: '" + charset + "'";
            throw new UnsupportedEncodingException(message);
        }
        this.charset = charset;
    }

    public void setHeaderFile(String fileName) {
        if (fileName == null || fileName.trim().length() == 0) {
            return;
        }
        this.filename = fileName;
    }

    private void loadHeaderFile() throws CheckstyleException {
        this.checkHeaderNotInitialized();
        InputStreamReader headerReader = null;
        try {
            URI uri = this.resolveHeaderFile();
            headerReader = new InputStreamReader((InputStream)new BufferedInputStream(uri.toURL().openStream()), this.charset);
            this.loadHeader(headerReader);
        }
        catch (IOException ex) {
            try {
                throw new CheckstyleException("unable to load header file " + this.filename, ex);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(headerReader);
                throw throwable;
            }
        }
        Utils.closeQuietly(headerReader);
    }

    private URI resolveHeaderFile() throws IOException {
        URI uri;
        try {
            URL url = new URL(this.filename);
            uri = url.toURI();
        }
        catch (MalformedURLException ex) {
            uri = null;
        }
        catch (URISyntaxException ex) {
            uri = null;
        }
        if (uri == null) {
            File file = new File(this.filename);
            if (file.exists()) {
                uri = file.toURI();
            } else {
                try {
                    URL configUrl = AbstractHeaderCheck.class.getResource(this.filename);
                    if (configUrl == null) {
                        throw new FileNotFoundException(this.filename);
                    }
                    uri = configUrl.toURI();
                }
                catch (URISyntaxException e) {
                    throw new FileNotFoundException(this.filename);
                }
            }
        }
        return uri;
    }

    private void checkHeaderNotInitialized() {
        if (!this.readerLines.isEmpty()) {
            throw new ConversionException("header has already been set - set either header or headerFile, not both");
        }
    }

    public void setHeader(String header) {
        if (header == null || header.trim().length() == 0) {
            return;
        }
        this.checkHeaderNotInitialized();
        String headerExpandedNewLines = header.replaceAll("\\\\n", "\n");
        StringReader headerReader = new StringReader(headerExpandedNewLines);
        try {
            this.loadHeader(headerReader);
        }
        catch (IOException ex) {
            throw new ConversionException("unable to load header", ex);
        }
        finally {
            Utils.closeQuietly(headerReader);
        }
    }

    private void loadHeader(Reader headerReader) throws IOException {
        String l;
        LineNumberReader lnr = new LineNumberReader(headerReader);
        this.readerLines.clear();
        while ((l = lnr.readLine()) != null) {
            this.readerLines.add(l);
        }
        this.postprocessHeaderLines();
    }

    protected void postprocessHeaderLines() {
    }

    @Override
    protected final void finishLocalSetup() throws CheckstyleException {
        if (this.filename != null) {
            this.loadHeaderFile();
        }
        if (this.readerLines.isEmpty()) {
            throw new CheckstyleException("property 'headerFile' is missing or invalid in module " + this.getConfiguration().getName());
        }
    }
}

