/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;

public class JavadocParagraphCheck
extends AbstractJavadocCheck {
    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{6, 10001};
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (ast.getType() == 6 && this.isEmptyLine(ast)) {
            this.checkEmptyLine(ast);
        } else if (ast.getType() == 10001 && JavadocUtils.getFirstChild(ast).getType() == 10006) {
            this.checkParagraphTag(ast);
        }
    }

    private void checkEmptyLine(DetailNode newline) {
        DetailNode nearestToken = this.getNearestNode(newline);
        if (!this.isLastEmptyLine(newline) && nearestToken != null && nearestToken.getType() == 10074 && nearestToken.getChildren().length > 1) {
            this.log(newline.getLineNumber(), "javadoc.paragraph.tag.after", new Object[0]);
        }
    }

    private void checkParagraphTag(DetailNode tag) {
        DetailNode newLine = this.getNearestEmptyLine(tag);
        if (this.isFirstParagraph(tag)) {
            this.log(tag.getLineNumber(), "javadoc.paragraph.redundant.paragraph", new Object[0]);
        } else if (newLine == null || tag.getLineNumber() - newLine.getLineNumber() != 1) {
            this.log(tag.getLineNumber(), "javadoc.paragraph.line.before", new Object[0]);
        }
    }

    private DetailNode getNearestNode(DetailNode node) {
        DetailNode tag = JavadocUtils.getNextSibling(node);
        while (tag != null && (tag.getType() == 1 || tag.getType() == 6)) {
            tag = JavadocUtils.getNextSibling(tag);
        }
        return tag;
    }

    private boolean isEmptyLine(DetailNode newLine) {
        DetailNode previousSibling = JavadocUtils.getPreviousSibling(newLine);
        if (previousSibling == null || previousSibling.getParent().getType() != 10000) {
            return false;
        }
        if (previousSibling.getType() == 10074 && previousSibling.getChildren().length == 1) {
            previousSibling = JavadocUtils.getPreviousSibling(previousSibling);
        }
        return previousSibling != null && previousSibling.getType() == 1;
    }

    private boolean isFirstParagraph(DetailNode paragraphTag) {
        DetailNode previousNode = JavadocUtils.getPreviousSibling(paragraphTag);
        while (previousNode != null) {
            if (previousNode.getType() == 10074 && previousNode.getChildren().length > 1 || previousNode.getType() != 1 && previousNode.getType() != 6 && previousNode.getType() != 10074) {
                return false;
            }
            previousNode = JavadocUtils.getPreviousSibling(previousNode);
        }
        return true;
    }

    private DetailNode getNearestEmptyLine(DetailNode node) {
        DetailNode newLine = JavadocUtils.getPreviousSibling(node);
        while (newLine != null) {
            DetailNode previousSibling = JavadocUtils.getPreviousSibling(newLine);
            if (newLine.getType() == 6 && this.isEmptyLine(newLine)) break;
            newLine = previousSibling;
        }
        return newLine;
    }

    private boolean isLastEmptyLine(DetailNode newLine) {
        DetailNode nextNode = JavadocUtils.getNextSibling(newLine);
        while (nextNode != null && nextNode.getType() != 10071) {
            if (nextNode.getType() == 10074 && nextNode.getChildren().length > 1 || nextNode.getType() == 10001) {
                return false;
            }
            nextNode = JavadocUtils.getNextSibling(nextNode);
        }
        return true;
    }
}

