/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;

public class FinalClassCheck
extends Check {
    private final FastStack<ClassDesc> classes = FastStack.newInstance();

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 8};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        if (ast.getType() == 14) {
            boolean isFinal = modifiers != null && modifiers.branchContains(39);
            boolean isAbstract = modifiers != null && modifiers.branchContains(40);
            this.classes.push(new ClassDesc(isFinal, isAbstract));
        } else if (!ScopeUtils.inEnumBlock(ast)) {
            ClassDesc desc = this.classes.peek();
            if (modifiers != null && modifiers.branchContains(61)) {
                desc.reportPrivateCtor();
            } else {
                desc.reportNonPrivateCtor();
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() != 14) {
            return;
        }
        ClassDesc desc = this.classes.pop();
        if (!desc.isDeclaredAsFinal() && !desc.isDeclaredAsAbstract() && desc.hasPrivateCtor() && !desc.hasNonPrivateCtor()) {
            String className = ast.findFirstToken(58).getText();
            this.log(ast.getLineNo(), "final.class", className);
        }
    }

    private static final class ClassDesc {
        private final boolean declaredAsFinal;
        private final boolean declaredAsAbstract;
        private boolean hasNonPrivateCtor;
        private boolean hasPrivateCtor;

        ClassDesc(boolean declaredAsFinal, boolean declaredAsAbstract) {
            this.declaredAsFinal = declaredAsFinal;
            this.declaredAsAbstract = declaredAsAbstract;
        }

        void reportPrivateCtor() {
            this.hasPrivateCtor = true;
        }

        void reportNonPrivateCtor() {
            this.hasNonPrivateCtor = true;
        }

        boolean hasPrivateCtor() {
            return this.hasPrivateCtor;
        }

        boolean hasNonPrivateCtor() {
            return this.hasNonPrivateCtor;
        }

        boolean isDeclaredAsFinal() {
            return this.declaredAsFinal;
        }

        boolean isDeclaredAsAbstract() {
            return this.declaredAsAbstract;
        }

        public String toString() {
            return this.getClass().getName() + "[" + "final=" + this.declaredAsFinal + " abstract=" + this.declaredAsAbstract + " pctor=" + this.hasPrivateCtor + " ctor=" + this.hasNonPrivateCtor + "]";
        }
    }
}

