/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.LineSeparatorOption;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.commons.beanutils.ConversionException;

public class NewlineAtEndOfFileCheck
extends AbstractFileSetCheck {
    private LineSeparatorOption lineSeparator = LineSeparatorOption.SYSTEM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFiltered(File file, List<String> lines) {
        RandomAccessFile randomAccessFile;
        block4: {
            randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                if (this.endsWithNewline(randomAccessFile)) break block4;
                this.log(0, "noNewlineAtEOF", file.getPath());
            }
            catch (IOException e) {
                try {
                    this.log(0, "unable.open", file.getPath());
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(randomAccessFile);
                    throw throwable;
                }
                Utils.closeQuietly(randomAccessFile);
            }
        }
        Utils.closeQuietly(randomAccessFile);
    }

    public void setLineSeparator(String lineSeparatorParam) {
        try {
            this.lineSeparator = Enum.valueOf(LineSeparatorOption.class, lineSeparatorParam.trim().toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + lineSeparatorParam, iae);
        }
    }

    private boolean endsWithNewline(RandomAccessFile randomAccessFile) throws IOException {
        int len = this.lineSeparator.length();
        if (randomAccessFile.length() < (long)len) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - (long)len);
        byte[] lastBytes = new byte[len];
        int readBytes = randomAccessFile.read(lastBytes);
        if (readBytes != len) {
            throw new IOException("Unable to read " + len + " bytes, got " + readBytes);
        }
        return this.lineSeparator.matches(lastBytes);
    }
}

