/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.LineColumn;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexpCheck
extends AbstractFormatCheck {
    private static final int DEFAULT_DUPLICATE_LIMIT = -1;
    private static final int DEFAULT_ERROR_LIMIT = 100;
    private static final String ERROR_LIMIT_EXCEEDED_MESSAGE = "The error limit has been exceeded, the check is aborting, there may be more unreported errors.";
    private String message = "";
    private boolean ignoreComments;
    private boolean illegalPattern;
    private int errorLimit = 100;
    private int duplicateLimit;
    private boolean checkForDuplicates;
    private int matchCount;
    private int errorCount;
    private Matcher matcher;

    public RegexpCheck() {
        super("$^", 8);
    }

    public void setMessage(String message) {
        this.message = message == null ? "" : message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public void setIllegalPattern(boolean illegalPattern) {
        this.illegalPattern = illegalPattern;
    }

    public void setErrorLimit(int errorLimit) {
        this.errorLimit = errorLimit;
    }

    public void setDuplicateLimit(int duplicateLimit) {
        this.duplicateLimit = duplicateLimit;
        this.checkForDuplicates = duplicateLimit > -1;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[0];
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        Pattern pattern = this.getRegexp();
        this.matcher = pattern.matcher(this.getFileContents().getText().getFullText());
        this.matchCount = 0;
        this.errorCount = 0;
        this.findMatch();
    }

    private void findMatch() {
        boolean ignore = false;
        boolean foundMatch = this.matcher.find();
        if (!foundMatch && !this.illegalPattern && this.matchCount == 0) {
            this.logMessage(0);
        } else if (foundMatch) {
            FileText text = this.getFileContents().getText();
            LineColumn start = text.lineColumn(this.matcher.start());
            LineColumn end = text.lineColumn(this.matcher.end() - 1);
            int startLine = start.getLine();
            int startColumn = start.getColumn();
            int endLine = end.getLine();
            int endColumn = end.getColumn();
            if (this.ignoreComments) {
                FileContents theFileContents = this.getFileContents();
                ignore = theFileContents.hasIntersectionWithComment(startLine, startColumn, endLine, endColumn);
            }
            if (!ignore) {
                ++this.matchCount;
                if (this.illegalPattern || this.checkForDuplicates && this.matchCount - 1 > this.duplicateLimit) {
                    ++this.errorCount;
                    this.logMessage(startLine);
                }
            }
            if (this.errorCount < this.errorLimit && (ignore || this.illegalPattern || this.checkForDuplicates)) {
                this.findMatch();
            }
        }
    }

    private void logMessage(int lineNumber) {
        String msg;
        String string = msg = "".equals(this.getMessage()) ? this.getFormat() : this.message;
        if (this.errorCount >= this.errorLimit) {
            msg = ERROR_LIMIT_EXCEEDED_MESSAGE + msg;
        }
        if (this.illegalPattern) {
            this.log(lineNumber, "illegal.regexp", msg);
        } else if (lineNumber > 0) {
            this.log(lineNumber, "duplicate.regexp", msg);
        } else {
            this.log(lineNumber, "required.regexp", msg);
        }
    }
}

