/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.regex.Pattern;

public class TodoCommentCheck
extends Check {
    private String format = "TODO:";
    private Pattern regexp = Pattern.compile(this.format);

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    public void setFormat(String format) {
        this.format = format;
        this.regexp = Pattern.compile(format);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{183};
    }

    @Override
    public void visitToken(DetailAST ast) {
        String[] lines = ast.getText().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!this.regexp.matcher(lines[i]).find()) continue;
            this.log(ast.getLineNo() + i, "todo.match", this.format);
        }
    }
}

