/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MissingOverrideCheck
extends Check {
    private static final String OVERRIDE = "Override";
    private static final String FQ_OVERRIDE = "java.lang.Override";
    private static final Pattern MATCH_INHERITDOC = Utils.createPattern("\\{\\s*@(inheritDoc)\\s*\\}");
    public static final String MSG_KEY_TAG_NOT_VALID_ON = "tag.not.valid.on";
    public static final String MSG_KEY_ANNOTATION_MISSING_OVERRIDE = "annotation.missing.override";
    private boolean javaFiveCompatibility;

    public void setJavaFiveCompatibility(boolean compatibility) {
        this.javaFiveCompatibility = compatibility;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{9};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST defOrNew;
        TextBlock javadoc = this.getFileContents().getJavadocBefore(ast.getLineNo());
        boolean containastag = this.containsJavadocTag(javadoc);
        if (containastag && !JavadocTagInfo.INHERIT_DOC.isValidOn(ast)) {
            this.log(ast.getLineNo(), MSG_KEY_TAG_NOT_VALID_ON, JavadocTagInfo.INHERIT_DOC.getText());
            return;
        }
        if (this.javaFiveCompatibility && ((defOrNew = ast.getParent().getParent()).branchContains(18) || defOrNew.branchContains(19) || defOrNew.getType() == 136)) {
            return;
        }
        if (containastag && !AnnotationUtility.containsAnnotation(ast, OVERRIDE) && !AnnotationUtility.containsAnnotation(ast, FQ_OVERRIDE)) {
            this.log(ast.getLineNo(), MSG_KEY_ANNOTATION_MISSING_OVERRIDE, new Object[0]);
        }
    }

    private boolean containsJavadocTag(TextBlock javadoc) {
        String[] lines;
        if (javadoc == null) {
            return false;
        }
        for (String line : lines = javadoc.getText()) {
            Matcher matchInheritDoc = MATCH_INHERITDOC.matcher(line);
            if (!matchInheritDoc.find()) continue;
            return true;
        }
        return false;
    }
}

