/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.HashMap;
import java.util.Map;

public class FinalLocalVariableCheck
extends Check {
    private final FastStack<Map<String, DetailAST>> scopeStack = FastStack.newInstance();

    @Override
    public int[] getDefaultTokens() {
        return new int[]{58, 8, 9, 10, 11, 12, 91, 7, 6};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 21};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{58, 8, 9, 11, 12, 91, 7, 6};
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 91: {
                this.scopeStack.push(new HashMap());
                break;
            }
            case 21: {
                if (ScopeUtils.inInterfaceBlock(ast) || FinalLocalVariableCheck.inAbstractOrNativeMethod(ast)) break;
            }
            case 10: {
                if (ast.getParent().getType() == 6 || ast.getParent().getType() == 156 || !FinalLocalVariableCheck.isFirstVariableInForInit(ast)) break;
                this.insertVariable(ast);
                break;
            }
            case 58: {
                int parentType = ast.getParent().getType();
                if (26 != parentType && 130 != parentType && 25 != parentType && 129 != parentType && 80 != parentType && 98 != parentType && 99 != parentType && 101 != parentType && 100 != parentType && 102 != parentType && 103 != parentType && 104 != parentType && 105 != parentType && 107 != parentType && 108 != parentType && 106 != parentType || ast.getParent().getFirstChild() != ast) break;
                this.removeVariable(ast);
                break;
            }
        }
    }

    private static boolean isFirstVariableInForInit(DetailAST variableDef) {
        return variableDef.getParent().getType() != 35 || variableDef.getPreviousSibling() == null || variableDef.getPreviousSibling().getType() != 74;
    }

    private static boolean inAbstractOrNativeMethod(DetailAST ast) {
        for (DetailAST parent = ast.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != 9) continue;
            DetailAST modifiers = parent.findFirstToken(5);
            return modifiers.branchContains(40) || modifiers.branchContains(66);
        }
        return false;
    }

    private void insertVariable(DetailAST ast) {
        if (!ast.branchContains(39)) {
            Map<String, DetailAST> state = this.scopeStack.peek();
            DetailAST astNode = ast.findFirstToken(58);
            state.put(astNode.getText(), astNode);
        }
    }

    private void removeVariable(DetailAST ast) {
        Map<String, DetailAST> state;
        DetailAST obj;
        for (int i = this.scopeStack.size() - 1; i >= 0 && (obj = (state = this.scopeStack.peek(i)).remove(ast.getText())) == null; --i) {
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        super.leaveToken(ast);
        switch (ast.getType()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 91: {
                Map<String, DetailAST> state = this.scopeStack.pop();
                for (DetailAST var : state.values()) {
                    this.log(var.getLineNo(), var.getColumnNo(), "final.variable", var.getText());
                }
                break;
            }
        }
    }
}

