/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class UnnecessaryParenthesesCheck
extends Check {
    private static final int MIN_CHILDREN_FOR_MATCH = 3;
    private static final int MAX_QUOTED_LENGTH = 25;
    private static final int[] LITERALS = new int[]{142, 140, 137, 141, 139, 135, 134, 133};
    private static final int[] ASSIGNMENTS = new int[]{80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    private DetailAST parentToSkip;
    private int assignDepth;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{28, 58, 142, 140, 137, 141, 139, 135, 134, 133, 80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    }

    @Override
    public void visitToken(DetailAST ast) {
        int type = ast.getType();
        boolean surrounded = this.isSurrounded(ast);
        DetailAST parent = ast.getParent();
        if (type == 80 && parent.getType() == 160) {
            return;
        }
        if (surrounded && type == 58) {
            this.parentToSkip = ast.getParent();
            this.log(ast, "unnecessary.paren.ident", ast.getText());
            return;
        }
        if (surrounded && this.inTokenList(type, LITERALS)) {
            this.parentToSkip = ast.getParent();
            if (type == 139) {
                this.log(ast, "unnecessary.paren.string", this.chopString(ast.getText()));
            } else {
                this.log(ast, "unnecessary.paren.literal", ast.getText());
            }
            return;
        }
        if (this.inTokenList(type, ASSIGNMENTS)) {
            ++this.assignDepth;
            DetailAST last = ast.getLastChild();
            if (last.getType() == 77) {
                this.log(ast, "unnecessary.paren.assign", new Object[0]);
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        int type = ast.getType();
        DetailAST parent = ast.getParent();
        if (type == 80 && parent.getType() == 160) {
            return;
        }
        if (type == 28) {
            if (this.parentToSkip != ast && this.exprSurrounded(ast)) {
                if (this.assignDepth >= 1) {
                    this.log(ast, "unnecessary.paren.assign", new Object[0]);
                } else if (ast.getParent().getType() == 88) {
                    this.log(ast, "unnecessary.paren.return", new Object[0]);
                } else {
                    this.log(ast, "unnecessary.paren.expr", new Object[0]);
                }
            }
            this.parentToSkip = null;
        } else if (this.inTokenList(type, ASSIGNMENTS)) {
            --this.assignDepth;
        }
        super.leaveToken(ast);
    }

    private boolean isSurrounded(DetailAST ast) {
        DetailAST prev = ast.getPreviousSibling();
        DetailAST next = ast.getNextSibling();
        return prev != null && prev.getType() == 76 && next != null && next.getType() == 77;
    }

    private boolean exprSurrounded(DetailAST ast) {
        if (ast.getType() != 28) {
            throw new IllegalArgumentException("Not an expression node.");
        }
        boolean surrounded = false;
        if (ast.getChildCount() >= 3) {
            DetailAST n1 = ast.getFirstChild();
            DetailAST nn = ast.getLastChild();
            surrounded = n1.getType() == 76 && nn.getType() == 77;
        }
        return surrounded;
    }

    private boolean inTokenList(int type, int[] tokens) {
        boolean found = false;
        for (int i = 0; i < tokens.length && !found; ++i) {
            found = tokens[i] == type;
        }
        return found;
    }

    private String chopString(String string) {
        if (string.length() > 25) {
            return string.substring(0, 25) + "...\"";
        }
        return string;
    }
}

