/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import antlr.collections.AST;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class VisibilityModifierCheck
extends Check {
    private boolean protectedAllowed;
    private boolean packageAllowed;
    private String publicMemberFormat = "^serialVersionUID$";
    private Pattern publicMemberPattern;

    public VisibilityModifierCheck() {
        this.setPublicMemberPattern(this.publicMemberFormat);
    }

    public boolean isProtectedAllowed() {
        return this.protectedAllowed;
    }

    public void setProtectedAllowed(boolean protectedAllowed) {
        this.protectedAllowed = protectedAllowed;
    }

    public boolean isPackageAllowed() {
        return this.packageAllowed;
    }

    public void setPackageAllowed(boolean packageAllowed) {
        this.packageAllowed = packageAllowed;
    }

    public void setPublicMemberPattern(String pattern) {
        try {
            this.publicMemberPattern = Utils.getPattern(pattern);
            this.publicMemberFormat = pattern;
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + pattern, e);
        }
    }

    private Pattern getPublicMemberRegexp() {
        return this.publicMemberPattern;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    public void visitToken(DetailAST ast) {
        String variableScope;
        if (ast.getType() != 10 || ast.getParent().getType() != 6) {
            return;
        }
        DetailAST varNameAST = this.getVarNameAST(ast);
        String varName = varNameAST.getText();
        boolean inInterfaceOrAnnotationBlock = ScopeUtils.inInterfaceOrAnnotationBlock(ast);
        Set<String> mods = this.getModifiers(ast);
        String declaredScope = this.getVisibilityScope(mods);
        String string = variableScope = inInterfaceOrAnnotationBlock ? "public" : declaredScope;
        if (!("private".equals(variableScope) || inInterfaceOrAnnotationBlock || mods.contains("static") && mods.contains("final") || "package".equals(variableScope) && this.isPackageAllowed() || "protected".equals(variableScope) && this.isProtectedAllowed() || "public".equals(variableScope) && this.getPublicMemberRegexp().matcher(varName).find())) {
            this.log(varNameAST.getLineNo(), varNameAST.getColumnNo(), "variable.notPrivate", varName);
        }
    }

    private DetailAST getVarNameAST(DetailAST variableDefAST) {
        DetailAST ast = variableDefAST.getFirstChild();
        while (ast != null) {
            DetailAST nextSibling = ast.getNextSibling();
            if (ast.getType() == 13) {
                return nextSibling;
            }
            ast = nextSibling;
        }
        return null;
    }

    private Set<String> getModifiers(DetailAST variableDefAST) {
        DetailAST modifiersAST = variableDefAST.getFirstChild();
        if (modifiersAST.getType() != 5) {
            throw new IllegalStateException("Strange parse tree");
        }
        HashSet<String> retVal = Sets.newHashSet();
        for (AST modifier = modifiersAST.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            retVal.add(modifier.getText());
        }
        return retVal;
    }

    private String getVisibilityScope(Set<String> modifiers) {
        String[] explicitModifiers;
        for (String candidate : explicitModifiers = new String[]{"public", "private", "protected"}) {
            if (!modifiers.contains(candidate)) continue;
            return candidate;
        }
        return "package";
    }
}

