/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class IllegalImportCheck
extends Check {
    private String[] illegalPkgs;

    public IllegalImportCheck() {
        this.setIllegalPkgs(new String[]{"sun"});
    }

    public void setIllegalPkgs(String[] from) {
        this.illegalPkgs = (String[])from.clone();
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{30, 152};
    }

    @Override
    public void visitToken(DetailAST ast) {
        FullIdent imp = ast.getType() == 30 ? FullIdent.createFullIdentBelow(ast) : FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
        if (this.isIllegalImport(imp.getText())) {
            this.log(ast.getLineNo(), ast.getColumnNo(), "import.illegal", imp.getText());
        }
    }

    private boolean isIllegalImport(String importText) {
        for (String element : this.illegalPkgs) {
            if (!importText.startsWith(element + ".")) continue;
            return true;
        }
        return false;
    }
}

