/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineSet;
import java.util.Arrays;

public abstract class ExpressionHandler {
    private final IndentationCheck indentCheck;
    private final DetailAST mainAst;
    private final String typeName;
    private final ExpressionHandler parent;
    private IndentLevel level;

    public ExpressionHandler(IndentationCheck indentCheck, String typeName, DetailAST expr, ExpressionHandler parent) {
        this.indentCheck = indentCheck;
        this.typeName = typeName;
        this.mainAst = expr;
        this.parent = parent;
    }

    public final IndentLevel getLevel() {
        if (this.level == null) {
            this.level = this.getLevelImpl();
        }
        return this.level;
    }

    protected IndentLevel getLevelImpl() {
        return this.parent.suggestedChildLevel(this);
    }

    public IndentLevel suggestedChildLevel(ExpressionHandler child) {
        return new IndentLevel(this.getLevel(), this.getBasicOffset());
    }

    protected final void logError(DetailAST ast, String subtypeName, int actualLevel) {
        this.logError(ast, subtypeName, actualLevel, this.getLevel());
    }

    protected final void logError(DetailAST ast, String subtypeName, int actualLevel, IndentLevel expectedLevel) {
        String typeStr = "".equals(subtypeName) ? "" : " " + subtypeName;
        String messageKey = "indentation.error";
        if (expectedLevel.isMultiLevel()) {
            messageKey = "indentation.error.multi";
        }
        this.indentCheck.indentationLog(ast.getLineNo(), messageKey, this.typeName + typeStr, actualLevel, expectedLevel);
    }

    private void logChildError(int line, int actualLevel, IndentLevel expectedLevel) {
        String messageKey = "indentation.child.error";
        if (expectedLevel.isMultiLevel()) {
            messageKey = "indentation.child.error.multi";
        }
        this.indentCheck.indentationLog(line, messageKey, this.typeName, actualLevel, expectedLevel);
    }

    protected final boolean startsLine(DetailAST ast) {
        return this.getLineStart(ast) == this.expandedTabsColumnNo(ast);
    }

    static boolean areOnSameLine(DetailAST ast1, DetailAST ast2) {
        return ast1 != null && ast2 != null && ast1.getLineNo() == ast2.getLineNo();
    }

    static DetailAST getFirstToken(DetailAST ast) {
        DetailAST first = ast;
        for (DetailAST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST toTest = ExpressionHandler.getFirstToken(child);
            if (toTest.getLineNo() >= first.getLineNo() && (toTest.getLineNo() != first.getLineNo() || toTest.getColumnNo() >= first.getColumnNo())) continue;
            first = toTest;
        }
        return first;
    }

    protected final int getLineStart(DetailAST ast) {
        String line = this.indentCheck.getLine(ast.getLineNo() - 1);
        return this.getLineStart(line);
    }

    protected final void checkLinesIndent(int startLine, int endLine, IndentLevel indentLevel) {
        this.checkSingleLine(startLine, indentLevel);
        IndentLevel offsetLevel = new IndentLevel(indentLevel, this.getBasicOffset());
        for (int i = startLine + 1; i <= endLine; ++i) {
            this.checkSingleLine(i, offsetLevel);
        }
    }

    protected boolean shouldIncreaseIndent() {
        return true;
    }

    private void checkLinesIndent(LineSet lines, IndentLevel indentLevel, boolean firstLineMatches, int firstLine) {
        if (lines.isEmpty()) {
            return;
        }
        int startLine = lines.firstLine();
        int endLine = lines.lastLine();
        int startCol = lines.firstLineCol();
        int realStartCol = this.getLineStart(this.indentCheck.getLine(startLine - 1));
        if (realStartCol == startCol) {
            this.checkSingleLine(startLine, startCol, indentLevel, firstLineMatches);
        }
        IndentLevel theLevel = indentLevel;
        if (firstLineMatches || firstLine > this.mainAst.getLineNo() && this.shouldIncreaseIndent()) {
            theLevel = new IndentLevel(indentLevel, this.getBasicOffset());
        }
        for (int i = startLine + 1; i <= endLine; ++i) {
            Integer col = lines.getStartColumn(i);
            if (col == null) continue;
            this.checkSingleLine(i, col, theLevel, false);
        }
    }

    private void checkSingleLine(int lineNum, IndentLevel indentLevel) {
        String line = this.indentCheck.getLine(lineNum - 1);
        int start = this.getLineStart(line);
        if (indentLevel.gt(start)) {
            this.logChildError(lineNum, start, indentLevel);
        }
    }

    private void checkSingleLine(int lineNum, int colNum, IndentLevel indentLevel, boolean mustMatch) {
        String line = this.indentCheck.getLine(lineNum - 1);
        int start = this.getLineStart(line);
        if (mustMatch ? !indentLevel.accept(start) : colNum == start && indentLevel.gt(start)) {
            this.logChildError(lineNum, start, indentLevel);
        }
    }

    protected final int getLineStart(String line) {
        for (int start = 0; start < line.length(); ++start) {
            char c = line.charAt(start);
            if (Character.isWhitespace(c)) continue;
            return Utils.lengthExpandedTabs(line, start, this.indentCheck.getIndentationTabWidth());
        }
        return 0;
    }

    protected final void checkChildren(DetailAST parent, int[] tokenTypes, IndentLevel startLevel, boolean firstLineMatches, boolean allowNesting) {
        Arrays.sort(tokenTypes);
        for (DetailAST child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (Arrays.binarySearch(tokenTypes, child.getType()) < 0) continue;
            this.checkExpressionSubtree(child, startLevel, firstLineMatches, allowNesting);
        }
    }

    protected final void checkExpressionSubtree(DetailAST tree, IndentLevel level, boolean firstLineMatches, boolean allowNesting) {
        LineSet subtreeLines = new LineSet();
        int firstLine = this.getFirstLine(Integer.MAX_VALUE, tree);
        if (firstLineMatches && !allowNesting) {
            subtreeLines.addLineAndCol(firstLine, this.getLineStart(this.indentCheck.getLine(firstLine - 1)));
        }
        this.findSubtreeLines(subtreeLines, tree, allowNesting);
        this.checkLinesIndent(subtreeLines, level, firstLineMatches, firstLine);
    }

    protected final int getFirstLine(int startLine, DetailAST tree) {
        int realStart = startLine;
        int currLine = tree.getLineNo();
        if (currLine < realStart) {
            realStart = currLine;
        }
        for (DetailAST node = tree.getFirstChild(); node != null; node = node.getNextSibling()) {
            realStart = this.getFirstLine(realStart, node);
        }
        return realStart;
    }

    protected final int expandedTabsColumnNo(DetailAST ast) {
        String line = this.indentCheck.getLine(ast.getLineNo() - 1);
        return Utils.lengthExpandedTabs(line, ast.getColumnNo(), this.indentCheck.getIndentationTabWidth());
    }

    protected final void findSubtreeLines(LineSet lines, DetailAST tree, boolean allowNesting) {
        if (this.getIndentCheck().getHandlerFactory().isHandledType(tree.getType()) || tree.getLineNo() < 0) {
            return;
        }
        int lineNum = tree.getLineNo();
        Integer colNum = lines.getStartColumn(lineNum);
        int thisLineColumn = this.expandedTabsColumnNo(tree);
        if (colNum == null || thisLineColumn < colNum) {
            lines.addLineAndCol(lineNum, thisLineColumn);
        }
        for (DetailAST node = tree.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.findSubtreeLines(lines, node, allowNesting);
        }
    }

    protected void checkModifiers() {
        DetailAST modifiers = this.mainAst.findFirstToken(5);
        for (DetailAST modifier = modifiers.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            if (!this.startsLine(modifier) || this.getLevel().accept(this.expandedTabsColumnNo(modifier))) continue;
            this.logError(modifier, "modifier", this.expandedTabsColumnNo(modifier));
        }
    }

    public abstract void checkIndentation();

    protected final IndentationCheck getIndentCheck() {
        return this.indentCheck;
    }

    protected final DetailAST getMainAst() {
        return this.mainAst;
    }

    protected final ExpressionHandler getParent() {
        return this.parent;
    }

    protected final int getBasicOffset() {
        return this.getIndentCheck().getBasicOffset();
    }

    protected final int getBraceAdjustement() {
        return this.getIndentCheck().getBraceAdjustement();
    }

    protected final void checkRParen(DetailAST lparen, DetailAST rparen) {
        if (rparen == null) {
            return;
        }
        int rparenLevel = this.expandedTabsColumnNo(rparen);
        if (this.getLevel().accept(rparenLevel) || !this.startsLine(rparen)) {
            return;
        }
        int lparenLevel = this.expandedTabsColumnNo(lparen);
        if (rparenLevel == lparenLevel + 1) {
            return;
        }
        this.logError(rparen, "rparen", rparenLevel);
    }

    protected final void checkLParen(DetailAST lparen) {
        if (lparen == null || this.getLevel().accept(this.expandedTabsColumnNo(lparen)) || !this.startsLine(lparen)) {
            return;
        }
        this.logError(lparen, "lparen", this.expandedTabsColumnNo(lparen));
    }
}

