/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.ImmutableSortedSet;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.HtmlTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.TagParser;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class JavadocStyleCheck
extends Check {
    private static final String UNCLOSED_HTML = "javadoc.unclosedhtml";
    private static final String EXTRA_HTML = "javadoc.extrahtml";
    private static final Set<String> SINGLE_TAGS = ImmutableSortedSet.of((Comparable)((Object)"br"), (Comparable)((Object)"li"), (Comparable)((Object)"dt"), (Comparable)((Object)"dd"), (Comparable)((Object)"hr"), (Comparable)((Object)"img"), (Comparable[])new String[]{"p", "td", "tr", "th"});
    private static final Set<String> ALLOWED_TAGS = ImmutableSortedSet.of((Comparable)((Object)"a"), (Comparable)((Object)"abbr"), (Comparable)((Object)"acronym"), (Comparable)((Object)"address"), (Comparable)((Object)"area"), (Comparable)((Object)"b"), (Comparable[])new String[]{"bdo", "big", "blockquote", "br", "caption", "cite", "code", "colgroup", "dd", "del", "div", "dfn", "dl", "dt", "em", "fieldset", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "ins", "kbd", "li", "ol", "p", "pre", "q", "samp", "small", "span", "strong", "style", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "tt", "u", "ul"});
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private String endOfSentenceFormat = "([.?!][ \t\n\r\f<])|([.?!]$)";
    private Pattern endOfSentencePattern;
    private boolean checkFirstSentence = true;
    private boolean checkHtml = true;
    private boolean checkEmptyJavadoc;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 157, 154, 9, 8, 10, 155, 161, 16};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.shouldCheck(ast)) {
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(ast.getFirstChild().getLineNo());
            this.checkComment(ast, cmt);
        }
    }

    private boolean shouldCheck(DetailAST ast) {
        if (ast.getType() == 16) {
            return this.getFileContents().inPackageInfo();
        }
        if (ScopeUtils.inCodeBlock(ast)) {
            return false;
        }
        Scope declaredScope = ast.getType() == 155 ? Scope.PUBLIC : ScopeUtils.getScopeFromMods(ast.findFirstToken(5));
        Scope scope = ScopeUtils.inInterfaceOrAnnotationBlock(ast) ? Scope.PUBLIC : declaredScope;
        Scope surroundingScope = ScopeUtils.getSurroundingScope(ast);
        return scope.isIn(this.scope) && (surroundingScope == null || surroundingScope.isIn(this.scope)) && (this.excludeScope == null || !scope.isIn(this.excludeScope) || surroundingScope != null && !surroundingScope.isIn(this.excludeScope));
    }

    private void checkComment(DetailAST ast, TextBlock comment) {
        if (comment == null) {
            if (this.getFileContents().inPackageInfo()) {
                this.log(ast.getLineNo(), "javadoc.missing", new Object[0]);
            }
            return;
        }
        if (this.checkFirstSentence) {
            this.checkFirstSentence(ast, comment);
        }
        if (this.checkHtml) {
            this.checkHtml(ast, comment);
        }
        if (this.checkEmptyJavadoc) {
            this.checkEmptyJavadoc(comment);
        }
    }

    private void checkFirstSentence(DetailAST ast, TextBlock comment) {
        String commentText = this.getCommentText(comment.getText());
        if (!(commentText.length() == 0 || this.getEndOfSentencePattern().matcher(commentText).find() || "{@inheritDoc}".equals(commentText) && JavadocTagInfo.INHERIT_DOC.isValidOn(ast))) {
            this.log(comment.getStartLineNo(), "javadoc.noperiod", new Object[0]);
        }
    }

    private void checkEmptyJavadoc(TextBlock comment) {
        String commentText = this.getCommentText(comment.getText());
        if (commentText.length() == 0) {
            this.log(comment.getStartLineNo(), "javadoc.empty", new Object[0]);
        }
    }

    private String getCommentText(String[] comments) {
        StringBuffer buffer = new StringBuffer();
        for (String line : comments) {
            int textStart = this.findTextStart(line);
            if (textStart == -1) continue;
            if (line.charAt(textStart) == '@') break;
            buffer.append(line.substring(textStart));
            this.trimTail(buffer);
            buffer.append('\n');
        }
        return buffer.toString().trim();
    }

    private int findTextStart(String line) {
        int textStart = -1;
        for (int i = 0; i < line.length(); ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            if (line.regionMatches(i, "/**", 0, "/**".length())) {
                i += 2;
                continue;
            }
            if (line.regionMatches(i, "*/", 0, 2)) {
                ++i;
                continue;
            }
            if (line.charAt(i) == '*') continue;
            textStart = i;
            break;
        }
        return textStart;
    }

    private void trimTail(StringBuffer buffer) {
        for (int i = buffer.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(buffer.charAt(i))) {
                buffer.deleteCharAt(i);
                continue;
            }
            if (i <= 0 || buffer.charAt(i - 1) != '*' || buffer.charAt(i) != '/') break;
            buffer.deleteCharAt(i);
            buffer.deleteCharAt(i - 1);
            --i;
            while (buffer.charAt(i - 1) == '*') {
                buffer.deleteCharAt(i - 1);
                --i;
            }
        }
    }

    private void checkHtml(DetailAST ast, TextBlock comment) {
        int lineno = comment.getStartLineNo();
        FastStack<HtmlTag> htmlStack = FastStack.newInstance();
        String[] text = comment.getText();
        List<String> typeParameters = CheckUtils.getTypeParameterNames(ast);
        TagParser parser = null;
        parser = new TagParser(text, lineno);
        while (parser.hasNextTag()) {
            HtmlTag tag = parser.nextTag();
            if (tag.isIncompleteTag()) {
                this.log(tag.getLineno(), "javadoc.incompleteTag", text[tag.getLineno() - lineno]);
                return;
            }
            if (tag.isClosedTag()) continue;
            if (!tag.isCloseTag()) {
                if (!this.isAllowedTag(tag)) continue;
                htmlStack.push(tag);
                continue;
            }
            if (this.isExtraHtml(tag.getId(), htmlStack)) {
                this.log(tag.getLineno(), tag.getPosition(), EXTRA_HTML, tag);
                continue;
            }
            this.checkUnclosedTags(htmlStack, tag.getId());
        }
        String lastFound = "";
        for (HtmlTag htag : htmlStack) {
            if (this.isSingleTag(htag) || htag.getId().equals(lastFound) || typeParameters.contains(htag.getId())) continue;
            this.log(htag.getLineno(), htag.getPosition(), UNCLOSED_HTML, htag);
            lastFound = htag.getId();
        }
    }

    private void checkUnclosedTags(FastStack<HtmlTag> htmlStack, String token) {
        FastStack<HtmlTag> unclosedTags = FastStack.newInstance();
        HtmlTag lastOpenTag = htmlStack.pop();
        while (!token.equalsIgnoreCase(lastOpenTag.getId())) {
            if (this.isSingleTag(lastOpenTag)) {
                lastOpenTag = htmlStack.pop();
                continue;
            }
            unclosedTags.push(lastOpenTag);
            lastOpenTag = htmlStack.pop();
        }
        String lastFound = "";
        for (HtmlTag htag : unclosedTags) {
            lastOpenTag = htag;
            if (lastOpenTag.getId().equals(lastFound)) continue;
            lastFound = lastOpenTag.getId();
            this.log(lastOpenTag.getLineno(), lastOpenTag.getPosition(), UNCLOSED_HTML, lastOpenTag);
        }
    }

    private boolean isSingleTag(HtmlTag tag) {
        return SINGLE_TAGS.contains(tag.getId().toLowerCase());
    }

    private boolean isAllowedTag(HtmlTag tag) {
        return ALLOWED_TAGS.contains(tag.getId().toLowerCase());
    }

    private boolean isExtraHtml(String token, FastStack<HtmlTag> htmlStack) {
        boolean isExtra = true;
        for (HtmlTag td : htmlStack) {
            if (!token.equalsIgnoreCase(td.getId())) continue;
            isExtra = false;
            break;
        }
        return isExtra;
    }

    public void setScope(String from) {
        this.scope = Scope.getInstance(from);
    }

    public void setExcludeScope(String scope) {
        this.excludeScope = Scope.getInstance(scope);
    }

    public void setEndOfSentenceFormat(String format) {
        this.endOfSentenceFormat = format;
    }

    private Pattern getEndOfSentencePattern() {
        if (this.endOfSentencePattern == null) {
            this.endOfSentencePattern = Pattern.compile(this.endOfSentenceFormat);
        }
        return this.endOfSentencePattern;
    }

    public void setCheckFirstSentence(boolean flag) {
        this.checkFirstSentence = flag;
    }

    public void setCheckHtml(boolean flag) {
        this.checkHtml = flag;
    }

    public void setCheckEmptyJavadoc(boolean flag) {
        this.checkEmptyJavadoc = flag;
    }
}

