/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;

public class SingleLineJavadocCheck
extends AbstractJavadocCheck {
    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (this.isSingleLineJavadoc() && (this.hasJavadocTags(ast) || this.hasJavadocInlineTags(ast))) {
            this.log(ast.getLineNumber(), "singleline.javadoc", new Object[0]);
        }
    }

    private boolean isSingleLineJavadoc() {
        DetailAST blockCommentStart = this.getBlockCommentAst();
        DetailAST blockCommentEnd = blockCommentStart.getLastChild();
        return blockCommentStart.getLineNo() == blockCommentEnd.getLineNo();
    }

    private boolean hasJavadocTags(DetailNode javadocRoot) {
        DetailNode javadocTagSection = JavadocUtils.findFirstToken(javadocRoot, 10071);
        return javadocTagSection != null;
    }

    private boolean hasJavadocInlineTags(DetailNode javadocRoot) {
        return JavadocUtils.branchContains(javadocRoot, 10072);
    }
}

