/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;

public final class AbstractClassNameCheck
extends AbstractFormatCheck {
    private static final String DEFAULT_FORMAT = "^Abstract.*$|^.*Factory$";
    private boolean ignoreModifier;
    private boolean ignoreName;

    public AbstractClassNameCheck() {
        super(DEFAULT_FORMAT);
    }

    public void setIgnoreModifier(boolean value) {
        this.ignoreModifier = value;
    }

    public void setIgnoreName(boolean value) {
        this.ignoreName = value;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (14 == ast.getType()) {
            this.visitClassDef(ast);
        }
    }

    private void visitClassDef(DetailAST ast) {
        String className = ast.findFirstToken(58).getText();
        if (this.isAbstract(ast)) {
            if (!this.ignoreName && !this.isMatchingClassName(className)) {
                this.log(ast.getLineNo(), ast.getColumnNo(), "illegal.abstract.class.name", className, this.getFormat());
            }
        } else if (!this.ignoreModifier && this.isMatchingClassName(className)) {
            this.log(ast.getLineNo(), ast.getColumnNo(), "no.abstract.class.modifier", className);
        }
    }

    private boolean isAbstract(DetailAST ast) {
        DetailAST abstractAST = ast.findFirstToken(5).findFirstToken(40);
        return abstractAST != null;
    }

    private boolean isMatchingClassName(String className) {
        return this.getRegexp().matcher(className).find();
    }
}

