/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractAccessControlNameCheck;

public class MethodNameCheck
extends AbstractAccessControlNameCheck {
    private boolean allowClassName;
    private static final String OVERRIDE = "Override";
    private static final String CANONICAL_OVERRIDE = "java.lang.Override";

    public MethodNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!AnnotationUtility.containsAnnotation(ast, OVERRIDE) && !AnnotationUtility.containsAnnotation(ast, CANONICAL_OVERRIDE)) {
            super.visitToken(ast);
        }
        if (!this.allowClassName) {
            DetailAST method = ast.findFirstToken(58);
            DetailAST classDefOrNew = ast.getParent().getParent();
            DetailAST classIdent = classDefOrNew.findFirstToken(58);
            if (null != classIdent && method.getText().equals(classIdent.getText())) {
                this.log(method.getLineNo(), method.getColumnNo(), "method.name.equals.class.name", method.getText());
            }
        }
    }

    public void setAllowClassName(boolean allowClassName) {
        this.allowClassName = allowClassName;
    }
}

