/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;

public class EmptyForInitializerPadCheck
extends AbstractOptionCheck<PadOption> {
    public EmptyForInitializerPadCheck() {
        super(PadOption.NOSPACE, PadOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{35};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getChildCount() == 0) {
            DetailAST semi = ast.getNextSibling();
            int semiLineIdx = semi.getLineNo() - 1;
            String line = this.getLines()[semiLineIdx];
            int before = semi.getColumnNo() - 1;
            if (!Utils.whitespaceBefore(before, line)) {
                PadOption option = (PadOption)((Object)this.getAbstractOption());
                if (PadOption.NOSPACE == option && Character.isWhitespace(line.charAt(before))) {
                    this.log(semi.getLineNo(), before, "ws.preceded", ";");
                } else if (PadOption.SPACE == option && !Character.isWhitespace(line.charAt(before))) {
                    this.log(semi.getLineNo(), before, "ws.notPreceded", ";");
                }
            }
        }
    }
}

