/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class NoWhitespaceBeforeCheck
extends Check {
    private boolean allowLineBreaks;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{45, 25, 26};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{45, 25, 26, 59};
    }

    @Override
    public void visitToken(DetailAST ast) {
        String line = this.getLine(ast.getLineNo() - 1);
        int before = ast.getColumnNo() - 1;
        if (before < 0 || Character.isWhitespace(line.charAt(before))) {
            DetailAST sibling;
            if (ast.getType() == 45 && (sibling = ast.getPreviousSibling()) != null && sibling.getType() == 35 && sibling.getChildCount() == 0) {
                return;
            }
            boolean flag = !this.allowLineBreaks;
            for (int i = 0; !flag && i < before; ++i) {
                if (Character.isWhitespace(line.charAt(i))) continue;
                flag = true;
            }
            if (flag) {
                this.log(ast.getLineNo(), before, "ws.preceded", ast.getText());
            }
        }
    }

    public void setAllowLineBreaks(boolean allowLineBreaks) {
        this.allowLineBreaks = allowLineBreaks;
    }
}

