/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;

public class DeclarationOrderCheck
extends Check {
    private static final int STATE_STATIC_VARIABLE_DEF = 1;
    private static final int STATE_INSTANCE_VARIABLE_DEF = 2;
    private static final int STATE_CTOR_DEF = 3;
    private static final int STATE_METHOD_DEF = 4;
    private final FastStack<ScopeState> scopeStates = FastStack.newInstance();
    private boolean ignoreConstructors;
    private boolean ignoreMethods;
    private boolean ignoreModifiers;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 9, 5, 6};
    }

    @Override
    public void visitToken(DetailAST ast) {
        int parentType = ast.getParent().getType();
        switch (ast.getType()) {
            case 6: {
                this.scopeStates.push(new ScopeState());
                break;
            }
            case 8: {
                if (parentType != 6) {
                    return;
                }
                ScopeState state = this.scopeStates.peek();
                if (state.scopeState > 3) {
                    if (this.ignoreConstructors) break;
                    this.log(ast, "declaration.order.constructor", new Object[0]);
                    break;
                }
                state.scopeState = 3;
                break;
            }
            case 9: {
                ScopeState state = this.scopeStates.peek();
                if (parentType != 6) {
                    return;
                }
                if (state.scopeState > 4) {
                    if (this.ignoreMethods) break;
                    this.log(ast, "declaration.order.method", new Object[0]);
                    break;
                }
                state.scopeState = 4;
                break;
            }
            case 5: {
                if (parentType != 10 || ast.getParent().getParent().getType() != 6) {
                    return;
                }
                ScopeState state = this.scopeStates.peek();
                if (ast.findFirstToken(64) != null) {
                    if (state.scopeState > 1) {
                        if (!this.ignoreModifiers || state.scopeState > 2) {
                            this.log(ast, "declaration.order.static", new Object[0]);
                        }
                    } else {
                        state.scopeState = 1;
                    }
                } else if (state.scopeState > 2) {
                    this.log(ast, "declaration.order.instance", new Object[0]);
                } else if (state.scopeState == 1) {
                    state.declarationAccess = Scope.PUBLIC;
                    state.scopeState = 2;
                }
                Scope access = ScopeUtils.getScopeFromMods(ast);
                if (state.declarationAccess.compareTo(access) > 0) {
                    if (this.ignoreModifiers) break;
                    this.log(ast, "declaration.order.access", new Object[0]);
                    break;
                }
                state.declarationAccess = access;
                break;
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 6: {
                this.scopeStates.pop();
                break;
            }
        }
    }

    public void setIgnoreConstructors(boolean ignoreConstructors) {
        this.ignoreConstructors = ignoreConstructors;
    }

    public void setIgnoreMethods(boolean ignoreMethods) {
        this.ignoreMethods = ignoreMethods;
    }

    public void setIgnoreModifiers(boolean ignoreModifiers) {
        this.ignoreModifiers = ignoreModifiers;
    }

    private static class ScopeState {
        private int scopeState = 1;
        private Scope declarationAccess = Scope.PUBLIC;

        private ScopeState() {
        }
    }
}

