/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.Arrays;

public class MagicNumberCheck
extends Check {
    private static final int[] ALLOWED_PATH_TOKENTYPES = new int[]{80, 29, 28, 32, 31, 23, 34, 136, 27, 60};
    private double[] ignoreNumbers = new double[]{-1.0, 0.0, 1.0, 2.0};
    private boolean ignoreHashCodeMethod;
    private boolean ignoreAnnotation;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{142, 140, 137, 141};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.ignoreAnnotation && this.isInAnnotation(ast)) {
            return;
        }
        if (this.inIgnoreList(ast) || this.ignoreHashCodeMethod && this.isInHashCodeMethod(ast)) {
            return;
        }
        DetailAST constantDefAST = this.findContainingConstantDef(ast);
        if (constantDefAST == null) {
            this.reportMagicNumber(ast);
        } else {
            for (DetailAST astNode = ast.getParent(); astNode != constantDefAST; astNode = astNode.getParent()) {
                int type = astNode.getType();
                if (Arrays.binarySearch(ALLOWED_PATH_TOKENTYPES, type) >= 0) continue;
                this.reportMagicNumber(ast);
                break;
            }
        }
    }

    private DetailAST findContainingConstantDef(DetailAST ast) {
        DetailAST varDefAST;
        for (varDefAST = ast; varDefAST != null && varDefAST.getType() != 10 && varDefAST.getType() != 155; varDefAST = varDefAST.getParent()) {
        }
        if (varDefAST == null) {
            return null;
        }
        if (ScopeUtils.inInterfaceOrAnnotationBlock(varDefAST) || varDefAST.getType() == 155) {
            return varDefAST;
        }
        DetailAST modifiersAST = varDefAST.findFirstToken(5);
        if (modifiersAST.branchContains(39)) {
            return varDefAST;
        }
        return null;
    }

    private void reportMagicNumber(DetailAST ast) {
        String text = ast.getText();
        DetailAST parent = ast.getParent();
        DetailAST reportAST = ast;
        if (parent.getType() == 31) {
            reportAST = parent;
            text = "-" + text;
        } else if (parent.getType() == 32) {
            reportAST = parent;
            text = "+" + text;
        }
        this.log(reportAST.getLineNo(), reportAST.getColumnNo(), "magic.number", text);
    }

    private boolean isInHashCodeMethod(DetailAST ast) {
        DetailAST methodDefAST;
        if (!ScopeUtils.inCodeBlock(ast)) {
            return false;
        }
        for (methodDefAST = ast.getParent(); null != methodDefAST && 9 != methodDefAST.getType(); methodDefAST = methodDefAST.getParent()) {
        }
        if (null == methodDefAST) {
            return false;
        }
        DetailAST identAST = methodDefAST.findFirstToken(58);
        if (!"hashCode".equals(identAST.getText())) {
            return false;
        }
        DetailAST paramAST = methodDefAST.findFirstToken(20);
        return 0 == paramAST.getChildCount();
    }

    private boolean inIgnoreList(DetailAST ast) {
        double value = CheckUtils.parseDouble(ast.getText(), ast.getType());
        DetailAST parent = ast.getParent();
        if (parent.getType() == 31) {
            value = -1.0 * value;
        }
        return Arrays.binarySearch(this.ignoreNumbers, value) >= 0;
    }

    public void setIgnoreNumbers(double[] list) {
        if (list == null || list.length == 0) {
            this.ignoreNumbers = new double[0];
        } else {
            this.ignoreNumbers = new double[list.length];
            System.arraycopy(list, 0, this.ignoreNumbers, 0, list.length);
            Arrays.sort(this.ignoreNumbers);
        }
    }

    public void setIgnoreHashCodeMethod(boolean ignoreHashCodeMethod) {
        this.ignoreHashCodeMethod = ignoreHashCodeMethod;
    }

    public void setIgnoreAnnotation(boolean ignoreAnnotation) {
        this.ignoreAnnotation = ignoreAnnotation;
    }

    private boolean isInAnnotation(DetailAST ast) {
        if (null == ast.getParent() || null == ast.getParent().getParent()) {
            return false;
        }
        return 159 == ast.getParent().getParent().getType() || 160 == ast.getParent().getParent().getType();
    }

    static {
        Arrays.sort(ALLOWED_PATH_TOKENTYPES);
    }
}

